package com.dss.sdk.api.enums;

/**
 * 可读话的枚举类型
 */
public interface ReadableEnum<E extends Enum<E>> {
    static <R extends Enum<R>> R getByReadValue(Class<? extends ReadableEnum<R>> readableClass, String readValue) {
        ReadableEnum<R>[] enumConstants = readableClass.getEnumConstants();
        for (ReadableEnum<R> enumConstant : enumConstants) {
            if (enumConstant.getReadValue().equals(readValue)) {
                return (R) enumConstant;
            }
        }
        return null;
    }

    static boolean isValidReadValue(Class<? extends ReadableEnum<?>> readableClass, String readValue) {
        for (ReadableEnum<?> enumConstant : readableClass.getEnumConstants()) {
            if (enumConstant.getReadValue().equals(readValue)) {
                return true;
            }
        }
        return false;
    }

    static String[] getReadValues(Class<? extends ReadableEnum<?>> readableClass) {
        ReadableEnum<?>[] enumConstants = readableClass.getEnumConstants();
        String[] readValues = new String[enumConstants.length];
        for (int i = 0; i < enumConstants.length; i++) {
            readValues[i] = enumConstants[i].getReadValue();
        }
        return readValues;
    }

    String getReadValue();
}
