package com.dss.sdk.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author Fadada
 */
@Getter
@AllArgsConstructor
public enum ReportStatusEnum {
    DOING("doing", "生成中"),
    FAIL("fail", "生成失败"),
    SUCCESS("success", "生成成功"),
    ;
    private final String status;
    private final String desc;

    public static boolean isValidKey(String status) {
        for (ReportStatusEnum reportStatusEnum : ReportStatusEnum.values()) {
            if (reportStatusEnum.status.equals(status)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isDoing(String status) {
        return DOING.status.equals(status);
    }

    public static boolean isSuccess(String status) {
        return SUCCESS.status.equals(status);
    }
}
