package com.dss.sdk.api.enums;

import com.dss.sdk.utils.string.StrUtil;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author Fadada
 */
@AllArgsConstructor
@Getter
public enum ReportTypeEnum {
    ELE_DATA_VALID_REPORT("fddEleDataValid", "法大大电子数据验证报告", ""),
    ELE_DATA_VALID_REPORT_CREDIT("fddEleDataValidCredit", "法大大个人征信电子授权电子数据验证报告", ""),
    ELE_SIGN_VERIFY_REPORT("fddContractSignVerify", "法大大文件签署电子数据验证报告", ""),
    CA_APPLY_REPORT("zxcaApply", "豸信CA证书申请报告", ""),
    CA_VERIFY_REPORT("zxcaVerify", "豸信CA验签报告", ""),
    CA_VERIFY_REPORT_CREDIT("zxcaVerifyCredit", "豸信CA个人征信电子授权电子签章验证报告", ""),
    TEDA_NOTARY_ELE_DATA_VALID_REPORT("tedaEleDataValid", "天津泰达公证处电子数据验证报告", ""),
    TEDA_NOTARY_ELE_DATA_VALID_REPORT_CREDIT("tedaEleDataValidCredit", "天津泰达公证处个人征信电子授权电子数据验证报告", ""),
    ;
    private final String type;
    private final String descCn;
    private final String descEn;

    public static String getDescByType(String type) {
        for (ReportTypeEnum reportTypeEnum : ReportTypeEnum.values()) {
            if (reportTypeEnum.type.equals(type)) {
                return reportTypeEnum.descCn;
            }
        }
        return StrUtil.EMPTY;
    }

    public static boolean isValidKey(String type) {
        for (ReportTypeEnum value : ReportTypeEnum.values()) {
            if (value.getType().equals(type)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isEleDataValidReport(String type) {
        return ELE_DATA_VALID_REPORT.type.equals(type);
    }

    public static boolean isEleDataValidCreditReport(String type) {
        return ELE_DATA_VALID_REPORT_CREDIT.type.equals(type);
    }

    public static boolean isCaApplyReport(String type) {
        return CA_APPLY_REPORT.type.equals(type);
    }

    public static boolean isCaVerifyReport(String type) {
        return CA_VERIFY_REPORT.type.equals(type);
    }

    public static boolean isCaVerifyCreditReport(String type) {
        return CA_VERIFY_REPORT_CREDIT.type.equals(type);
    }
}
