package com.dss.sdk.api.enums;

import lombok.Getter;

@Getter
public enum ResultTypeEnum implements ReadableEnum<ResultTypeEnum> {

    NOT_REDIRECT("non_redirect", "不自动跳转"),
    SUCCESS_REDIRECT("success_redirect", "成功跳转，失败不跳转"),
    BOTH_REDIRECT("all_redirect", "认证无论是否通过，都直接跳转");

    /**
     * 字段值
     */
    private final String type;
    /**
     * 字段值的实际意义
     */
    private final String value;

    ResultTypeEnum(String type, String value) {
        this.type = type;
        this.value = value;
    }

    @Override
    public String getReadValue() {
        return type;
    }
}
