package com.dss.sdk.api.enums;

import java.util.ArrayList;
import java.util.List;

/**
 * <h3>概要:</h3> 
 *    签章查找关键字策略：所有关键字签章、第一个关键字签章、最后一个关键字签章。
 * <br>
 * <h3>功能:</h3>
 * <ol>
 *
 * </ol>
 * <h3>履历:</h3>
 * <ol>
 * </ol>
 */
public enum SearchStrategyEnum implements ReadableEnum<SearchStrategyEnum> {
    /**
     * 所有关键字签章
     */
    ALL(0, "所有关键字签章"),
    /**
     * 第一个关键字签章
     */
    FIRST(1, "第一个关键字签章"),
    /**
     * 最后一个关键字签章
     */
    LAST(2, "最后一个关键字签章");

    /** 字段值 */
    private Integer value;

    /** 字段值的实际意义 */
    private String valueInFact;

    public Integer getValue() {
        return value;
    }

    public String getValueInFact() {
        return valueInFact;
    }

    /**
     * <b>概要：</b>
     * 	根据属性值匹配属性
     * <b>作者：</b>SUXH </br>
     * <b>日期：</b>2015-3-17 </br>
     * @param value 需要匹配的属性值
     * @return
     */
    public static SearchStrategyEnum convertByValue(Integer value) {
        for (SearchStrategyEnum searchStrategyEnum : SearchStrategyEnum.values()) {
            if (searchStrategyEnum.getValue().equals(value)) {
                return searchStrategyEnum;
            }
        }
        return null;
    }

    /**
     * <b>概要：</b>
     * 	获得枚举的所有值（all value）
     * <b>作者：</b>SUXH </br>
     * <b>日期：</b>2015-3-31 </br>
     * @return 枚举的所有值
     */
    public static List<Integer> getValueList() {
        List<Integer> values = new ArrayList<Integer>();
        SearchStrategyEnum[] searchStrategyEnumArr = SearchStrategyEnum.values();
        for (SearchStrategyEnum i : searchStrategyEnumArr) {
            values.add(i.getValue());
        }
        return values;
    }

    /**
     * 判断参数合法性
     */
    public static boolean isValidKey(Integer key) {
        return getValueList().contains(key);
    }

    SearchStrategyEnum(Integer value, String valueInFact) {
        this.value = value;
        this.valueInFact = valueInFact;
    }

    public static SearchStrategyEnum getByName(String name, SearchStrategyEnum defaultValue) {
        for (SearchStrategyEnum searchStrategyEnum : SearchStrategyEnum.values()) {
            if (searchStrategyEnum.name().equalsIgnoreCase(name)) {
                return searchStrategyEnum;
            }
        }
        return defaultValue;
    }

    @Override
    public String getReadValue() {
        return this.name().toLowerCase();
    }

}
