package com.dss.sdk.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.ArrayList;
import java.util.List;

/**
 * <h3>概要:</h3> 
 *    签章位置策略
 * <br>
 * <h3>功能:</h3>
 * <ol>
 * </ol>
 * <h3>履历:</h3>
 * <ol>
 * </ol>
 */
@Getter
@AllArgsConstructor
public enum SignRuleTypeEnum implements ReadableEnum<SignRuleTypeEnum> {
    /**
     * 按照坐标信息签章
     */
    LOCATION_SIGN(2, "location","按照坐标信息签章"),
    /**
     * 按照关键字签章
     */
    KEYWORD_SIGN(3, "keyword","按照关键字签章"),
    /**
     * 按照签名域签章
     */
    SIGNATURE_FIELD_SIGN(1, "signField","按照签名域签章");
    /** 字段值 */
    private Integer value;

    private String readValue;

    /** 字段值的实际意义 */
    private String valueInFact;


    /**
     * <b>概要：</b>
     * 	根据属性值匹配属性
     * <b>作者：</b>SUXH </br>
     * <b>日期：</b>2015-3-17 </br>
     * @param value 需要匹配的属性值
     * @return
     */
    public static SignRuleTypeEnum convertByValue(Integer value) {
        for (SignRuleTypeEnum signRuleTypeEnum : SignRuleTypeEnum.values()) {
            if (signRuleTypeEnum.getValue().equals(value)) {
                return signRuleTypeEnum;
            }
        }
        return null;
    }

    /**
     * <b>概要：</b>
     * 	获得枚举的所有值（all value）
     * <b>作者：</b>SUXH </br>
     * <b>日期：</b>2015-3-31 </br>
     * @return 枚举的所有值
     */
    public static List<Integer> getValueList() {
        List<Integer> values = new ArrayList<Integer>();
        SignRuleTypeEnum[] signRuleTypeEnumArr = SignRuleTypeEnum.values();
        for (SignRuleTypeEnum i : signRuleTypeEnumArr) {
            values.add(i.getValue());
        }
        return values;
    }

    /**
     * 判断参数合法性
     */
    public static boolean isValidKey(Integer key) {
        return getValueList().contains(key);
    }

    SignRuleTypeEnum(Integer value, String valueInFact) {
        this.value = value;
        this.valueInFact = valueInFact;
    }

    // getByReadName
    public static SignRuleTypeEnum getByReadName(String readValue) {
        for (SignRuleTypeEnum signRuleTypeEnum : SignRuleTypeEnum.values()) {
            if (signRuleTypeEnum.getReadValue().equals(readValue)) {
                return signRuleTypeEnum;
            }
        }
        return null;
    }

}
