package com.dss.sdk.api.enums;

import lombok.Getter;

@Getter
public enum TableFontStyleEnum implements ReadableEnum<TableFontStyleEnum> {
    NORMAL(0, "normal", "正常"),
    BOLD(1, "bold", "粗体"),
    ITALIC(2, "italic", "斜体");

    private final Integer value;
    private final String type;
    private final String desc;

    TableFontStyleEnum(Integer value, String type, String desc) {
        this.value = value;
        this.type = type;
        this.desc = desc;
    }

    @Override
    public String getReadValue() {
        return type;
    }
}
