package com.dss.sdk.api.enums;

import lombok.Getter;

/**
 * @author Fadada
 * @Date 2023/2/6 11:33
 */
@Getter
public enum TableHeaderDirectionEnum implements ReadableEnum<TableHeaderDirectionEnum> {
    HORIZON(1, "水平方向"),
    VERTICALS(2, "垂直方向"),
    ;
    private Integer type;
    private String desc;

    TableHeaderDirectionEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    @Override
    public String getReadValue() {
        return name().toLowerCase();
    }
}
