package com.dss.sdk.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum TextWidgetAlignTypeEnum implements ReadableEnum<TextWidgetAlignTypeEnum> {
    LEFT(0, "居左"),
    CENTER(1, "居中"),
    RIGHT(2, "居右"),
    ;
    private final int value;
    private final String valueInFact;

    @Override
    public String getReadValue() {
        return name().toLowerCase();
    }
}
