package com.dss.sdk.api.factory;

import com.dss.sdk.api.client.*;
import com.dss.sdk.api.client.merge.MergeApiClient;
import com.dss.sdk.api.service.DssClientService;
import com.dss.sdk.config.HttpConfig;

import javax.tools.Tool;

/**
 * $
 *
 * @author Fadada
 * @version 2.0.0
 * @date: 2024/7/9
 */
public class DssApiSdkFactory {
    /**
     * dssClient
     */
    private static DssClientService clientService;
    /**
     * 各种业务client
     */
    public static FileOperateClient fileOperateClient;
    public static FileSignClient fileSignClient;
    public static FileTransferClient fileTransferClient;
    public static FileVerifyClient fileVerifyClient;
    public static ReportClient reportClient;
    public static SealApiClient sealApiClient;
    public static ZxcaApiClient zxcaApiClient;
    public static MergeApiClient mergeApiClient;
    public static ToolApiClient toolApiClient;

    /**
     * 初始化
     */
    public static void init(String serverUrl, String appId, String appSecret) {
        clientService = new DssClientService(serverUrl, appId, appSecret);
        DssApiSdkFactory.Transaction();
    }

    public static void init(String serverUrl, String appId, String appSecret, HttpConfig httpConfig) {
        clientService = new DssClientService(serverUrl, appId, appSecret, httpConfig);
        DssApiSdkFactory.Transaction();
    }

    private static void Transaction() {
        fileOperateClient = new FileOperateClient(clientService);
        fileSignClient = new FileSignClient(clientService);
        fileTransferClient = new FileTransferClient(clientService);
        fileVerifyClient = new FileVerifyClient(clientService);
        reportClient = new ReportClient(clientService);
        sealApiClient = new SealApiClient(clientService);
        zxcaApiClient = new ZxcaApiClient(clientService);
        mergeApiClient = new MergeApiClient(clientService);
        toolApiClient = new ToolApiClient(clientService);
    }
}
