package com.dss.sdk.api.req;

import com.dss.sdk.api.base.BaseDssRequest;
import lombok.Data;
import lombok.experimental.Accessors;

@Data
@Accessors(chain = true)
public class ApiCorpTransCreateRequest extends BaseDssRequest {

    /**
     * 经办人认证订单号
     */
    private String operatorUserTransactionId;

    /**
     * 方案ID 为空时默认获取应用ID下的默认方案ID
     */
    private String planId;

    /**
     * 客户系统中的用户唯一标识
     */
    private String clientId;

    /**
     * 认证结果通知手机号（当需要短信通知认证结果时，该字段必填）
     */
    private String notifyMobile;

    /**
     * 是否短信通知认证结果
     */
    private String smsNotify;

    /**
     * 异步回调地址
     */
    private String notifyUrl;

    /**
     * 证书算法
     */
    private String certAlg;
}
