package com.dss.sdk.api.req;

import com.dss.sdk.api.base.BaseDssRequest;
import com.dss.sdk.api.dto.ZxcaCorpOperatorUserInfo;
import com.dss.sdk.api.enums.CertAlgEnum;
import com.dss.sdk.api.enums.CorpTypeEnum;
import com.dss.sdk.api.enums.ResultTypeEnum;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

@Data
@Accessors(chain = true)
public class CertApplyCompanyRequest extends BaseDssRequest {
    /**
     * 经办人认证订单ID
     */
    private String operatorUserTransactionId;

    /**
     * 客户系统中的用户唯一标识
     */
    private String clientId;

    /**
     * 企业主体类型 详见字典
     */
    private String corpType = CorpTypeEnum.COMPANY.getType();

    /**
     * 企业全称
     */
    private String corpFullName;

    /**
     * 统一社会信用代码或其他等同的编码
     */
    private String corpUnifiedIdentifier;

    /**
     * 法定代表人/经营者(如个体工商户的)/负责人的姓名
     */
    private String legalRepName;

    /**
     * 异步回调地址
     */
    private String notifyUrl;
    /**
     * 同步回调类型，同步回调类型:0-不自动跳转,1-成功跳转,失败不跳转,2-都跳转
     */
    private String resultType = ResultTypeEnum.SUCCESS_REDIRECT.getType();
    /**
     * 同步回调地址
     */
    private String returnUrl;

    /**
     * 不可修改字段集合，指定字段且相应字段有传入值时；用户无法在认证页面中修改传入的信息，只能以指定信息进行认证；
     */
    private List<String> nonEditableInfo;

    /**
     * 方案ID 为空时默认获取应用ID下的默认方案ID
     */
    private String planId;

    private String certAlg = CertAlgEnum.ALL.getValue();

    /**
     * 经办人身份信息（当operatorUserTransactionId为空时，此参数才会生效，可以指定企业认证中经办人的身份信息）
     */
    private ZxcaCorpOperatorUserInfo operatorUserInfo;

}
