package com.dss.sdk.api.req;

import com.dss.sdk.api.base.BaseDssRequest;
import com.dss.sdk.api.enums.CertAlgEnum;
import com.dss.sdk.api.enums.IdCertTypeEnum;
import com.dss.sdk.api.enums.ResultTypeEnum;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

@Data
@Accessors(chain = true)
public class CertApplyPersonRequest extends BaseDssRequest {
    /**
     * 客户系统中的用户唯一标识
     */
    private String clientId;
    /**
     * 姓名
     */
    private String realName;

    /**
     * 个人证件类型 详见字典
     */
    private String idCertType = IdCertTypeEnum.IDENTITY_CARD.getType();

    /**
     * 证件号码
     */
    private String idCertNo;

    /**
     * 手机号码
     */
    private String mobile;

    /**
     * 银行账户号码
     */
    private String bankAccountNo;
    /**
     * 异步回调地址
     */
    private String notifyUrl;
    /**
     * 同步回调类型，同步回调类型:0-不自动跳转,1-成功跳转,失败不跳转,2-都跳转
     * success_redirect 成功跳转，失败不跳转
     * non_redirect 不跳转
     * all_redirect 认证无论是否通过，都直接跳转
     */
    private String resultType = ResultTypeEnum.SUCCESS_REDIRECT.getType();
    /**
     * 同步回调地址
     */
    private String returnUrl;

    /**
     * 不可修改字段集合，指定字段且相应字段有传入值时；用户无法在认证页面中修改传入的信息，只能以指定信息进行认证；
     * realName,idCertType,idCertNo,mobile,bankAccountNo
     */
    private List<String> nonEditableInfo;

    /**
     * 允许的认证方式集合，认证页面中只会显示此参数中传入的认证方式；传空时，用户可选择全部认证方式（受证件类型限制）；详见字典
     * mobile,face,bank_account,manual_audit
     */
    private List<String> supportVerificationMode;
    /**
     * 方案ID 为空时默认获取应用ID下的默认方案ID
     */
    private String planId;

    /**
     * 证书算法
     */
    private String certAlg = CertAlgEnum.ALL.getValue();
}
