package com.dss.sdk.api.req;

import com.dss.sdk.api.base.BaseDssRequest;
import lombok.Data;
import lombok.RequiredArgsConstructor;
import lombok.experimental.Accessors;

@Accessors(chain = true)
@RequiredArgsConstructor(staticName = "of")
@Data
public class CertPageRequest extends BaseDssRequest {
    /**
     * 企业或个人的唯一标识，企业或个人的唯一标识。该参数由平台自定义，长度最大64个字符。
     */
    private String clientId;
    /**
     * 证书编号，证书编号，证书唯一标识，用于文件签署
     */
    private String certificateId;
    /**
     * 证书主体名称，证书主体名称，个人为姓名，企业为企业全称
     */
    private String name;
    /**
     * 证书主体身份编码，证书主体身份编码，个人为身份证，企业为组织机构代码
     */
    private String identNo;
    /**
     * 证书类型，证书类型，取值范围：
     * personal（个人证书）
     * corporate（企业证书）
     */
    private String certType;
    /**
     * 证书颁发结束时间，格式yyyy-MM-dd HH:mm:ss
     */
    private String awardEndTime;
    /**
     * 证书颁发开始时间，格式yyyy-MM-dd HH:mm:ss
     */
    private String awardStartTime;
    /**
     * 证书失效开始时间，格式yyyy-MM-dd HH:mm:ss
     */
    private String invalidEndTime;
    /**
     * 证书失效开始时间，格式yyyy-MM-dd HH:mm:ss
     */
    private String invalidStartTime;
    /**
     * 游标，用于分页查询，第一次查询不传。
     */
    private String cursor;
    /**
     * 每页数量，默认为10，取值范围1-500。
     */
    private Integer limit;
}
