package com.dss.sdk.api.req;

import com.dss.sdk.api.base.BaseDssRequest;
import com.dss.sdk.api.enums.AccessTypeEnum;
import com.dss.sdk.api.enums.EuiPageTypeEnum;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class EuiCommonRequest extends BaseDssRequest {
    /**
     * 访问码，预览页面访问码，6位数字+字母（区分大小写）不支持中文和特殊字符。
     */
    private String accessCode;

    /**
     * 访问方式，取值：unlimited: 不做访问限制（默认）； accessCode：访问码；verifiedCode：手机验证码
     */
    private String accessType = AccessTypeEnum.UNLIMITED.getReadValue();

    /**
     * 页面样式，页面终端适配方式，adaptive：自适应（默认）；pc：PC；h5：H5
     */
    private String clientPageType = EuiPageTypeEnum.ADAPTIVE.getReadValue();

    /**
     * 链接有效期，URL有效期，以分钟为单位进行设置，大于等于0的正整数，不传则默认10080分钟（7天），最长有效期为一年，传0则默认按最长有效期
     */
    private Integer urlTimeout = 10080;

    private String notifyUrl;

    /**
     * 业务完成跳转地址
     */
    private String returnUrl;

    /**
     * 手机号区号，非必传，默认+86，传参时需带“+”号
     */
    private String areaCode;
    /**
     * 手机号
     */
    private String mobile;
}
