package com.dss.sdk.api.req;

import com.dss.sdk.api.base.BaseDssRequest;
import com.dss.sdk.api.dto.*;
import com.dss.sdk.api.req.evidence.SelfVerificationInfo;

import java.util.List;

/**
 * FileSignSignRequest
 *
 * @author Fadada
 */
@lombok.Data
public class FileSignSignRequest extends BaseDssRequest {
    /**
     * 文件在本地电子签系统的唯一识别标识
     */
    private String fileId;
    /**
     * 是否使用副本签署
     */
    private boolean useCopy = false;
    /**
     * 业务自定义签署交易号，最大长度64位
     */
    private String transactionId;
    /**
     * 短信验证码
     */
    private String verificationCode;
    /**
     * 自定义坐标参考系信息。
     */
    private CoordinateInfo coordinateInfo;
    /**
     * 支持传入多组不同位置的个人或企业签章
     */
    private List<DocSignSealInfo> sealInfos;
    /**
     * 详见日期章信息，支持传入多组不同位置的日期章
     */
    private List<DocSignDateSealInfo> dateSealInfos;
    /**
     * 详见备注章信息，支持传入多组不同位置的备注章
     */
    private List<DocSignRemarkSealInfo> remarkSealInfos;
    /**
     * 详见骑缝章信息
     */
    private List<DocSignAcrossSealInfo> acrossSealInfos;
    /**
     * 平台自行意愿确认的数据存证
     */
    private SelfVerificationInfo preservationVerifiedResult;
}
