package com.dss.sdk.api.req;


import com.dss.sdk.api.dto.DocSignInfo;
import com.dss.sdk.api.dto.VideoQuestionInfo;
import com.dss.sdk.api.req.evidence.SelfVerificationInfo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
public class FileSignUrlRequest extends EuiCommonRequest {

    /**
     * 业务自定义签署交易号，最大长度64位
     */
    private String transactionId;
    /**
     * 文件签署信息列表
     */
    private List<DocSignInfo> docSignInfos;

    /**
     * 是否使用副本，是否使用文件副本。false（默认）: 在源文件上操作； true: 创建一个文件副本，并在副本上操作，源文件保持不变 。
     */
    private Boolean useCopy = false;
    /**
     * 法大大意愿校验方式,SMS,短信验证；FACE,刷脸验证；支持独立选择一种或多种，选择多种时用逗号分隔，签署方自行选择不支持组合使用，不传值时，不使用法大大意愿校验
     */
    private String verifyMode;
    /**
     * 第三方意愿校验地址，不使用本平台意愿校验时，可以传入第三方意愿校验地址，用于本次签署意愿校验。
     */
    private String verifyUrl;

    /**
     * 意愿校验方式为“FACE,刷脸验证”且签署信息无个人证书时，必传。该字段仅支持传个人证书Id，用于刷脸验证时比对人脸信息。如签署信息已存在个人证书时，默认采用签署信息中的个人证书刷脸比对。
     */
    private String verifyCertificateId;

    /**
     * 音视频双录-意愿校验信息
     */
    private VideoQuestionInfo verifyInfo;

    /**
     * 是否所有文件需阅读至末页才可提交，FALSE ：否（默认）；TRUE：是
     */
    private Boolean readFinalPage = false;
    /**
     * 阅读多久后才可提交签署，默认为0，可设置秒数范围，1-60秒
     */
    private Integer readingTime = 0;
    /**
     * 平台自行意愿确认的数据存证
     */
    private SelfVerificationInfo preservationVerifiedResult;
}

