package com.dss.sdk.api.req;


import com.dss.sdk.annotation.ValidField;
import com.dss.sdk.api.base.BaseDssRequest;
import com.dss.sdk.api.dto.FaceVerificationInfo;
import com.dss.sdk.api.dto.MobileVerificationInfo;
import com.dss.sdk.api.req.evidence.SelfVerificationInfo;
import lombok.Data;

@Data
public class FileSignVerifyRequest extends BaseDssRequest {

    /**
     * 业务自定义签署交易号，最大长度64位
     */
    @ValidField(required = true, maxLength = 64)
    private String transactionId;

    /**
     * 校验ID，本次校验的唯一ID
     */
    @ValidField(required = true, maxLength = 64)
    private String signId;

    /**
     * 平台自行意愿确认的数据存证
     */
    private SelfVerificationInfo preservationVerifiedResult;
}

