package com.dss.sdk.api.req;

import com.dss.sdk.api.base.BaseDssRequest;
import com.dss.sdk.api.enums.CertAlgEnum;
import com.dss.sdk.api.req.evidence.RAPreservationCorpDetail;
import lombok.Data;
import lombok.experimental.Accessors;

@Data
@Accessors(chain = true)
public class RaCertApplyCompanyRequest extends BaseDssRequest {
    /**
     * 客户系统中的用户唯一标识
     */
    private String clientId;
    /**
     * 企业全称
     */
    private String corpFullName;

    /**
     * 统一社会信用代码或其他等同的编码
     */
    private String corpUnifiedIdentifier;

    /**
     * 法定代表人/经营者(如个体工商户的)/负责人的姓名
     */
    private String legalRepName;

    /**
     * 方案ID 为空时默认获取应用ID下的默认方案ID
     */
    private String planId;

    private String certAlg = CertAlgEnum.ALL.getValue();

    /**
     * 平台自行实名认证的数据存证
     */
    private RAPreservationCorpDetail preservationInfo;
}
