package com.dss.sdk.api.req;

import com.dss.sdk.api.base.BaseDssRequest;
import com.dss.sdk.api.enums.CertAlgEnum;
import com.dss.sdk.api.enums.IdCertTypeEnum;
import com.dss.sdk.api.req.evidence.RAPreservationUserDetail;
import lombok.Data;
import lombok.experimental.Accessors;

@Data
@Accessors(chain = true)
public class RaCertApplyPersonRequest extends BaseDssRequest {
    /**
     * 客户系统中的用户唯一标识
     */
    private String clientId;
    /**
     * 姓名
     */
    private String realName;

    /**
     * 个人证件类型 详见字典
     */
    private String idCertType = IdCertTypeEnum.IDENTITY_CARD.getType();

    /**
     * 证件号码
     */
    private String idCertNo;

    /**
     * 方案ID 为空时默认获取应用ID下的默认方案ID
     */
    private String planId;

    /**
     * 证书算法
     */
    private String certAlg = CertAlgEnum.ALL.getValue();

    /**
     * 平台自行实名认证的数据存证
     */
    private RAPreservationUserDetail preservationInfo;
}
