package com.dss.sdk.api.req;

import com.dss.sdk.api.base.BaseDssRequest;
import com.dss.sdk.api.enums.ReportTypeEnum;
import lombok.Data;

/**
 * @author Fadada
 * @date 2024/5/20 0020 16:28
 */
@Data
public class ReportApplyRequest extends BaseDssRequest {
    /**
     * 业务系统定义的申请出证流水号
     */
    private String outApplyNo;
    /**
     * 文件在本地电子签系统的唯一识别标识
     */
    private String fileId;
    private String fileName;
    private String fileUrl;
    /**
     * @see ReportTypeEnum
     */
    private String reportType = ReportTypeEnum.ELE_DATA_VALID_REPORT.getType();
    /**
     * 异步回调地址，向该地址进行信息回调
     */
    private String notifyUrl;
    /**
     * 天津泰达相关报告生效。公证处审计要求将在其系统中留存报告，可设置报告是否附加电子文件
     */
    private Boolean attachFile = false;
}
