package com.dss.sdk.api.req;

import lombok.Data;
import lombok.EqualsAndHashCode;


@Data
@EqualsAndHashCode(callSuper = true)
public class SealCreateDrawUrlRequest extends EuiCommonRequest {
    /**
     * 业务自定义签署交易号，最大长度64位
     */
    private String transactionId;

    /**
     * 企业或个人的唯一标识，企业或个人的唯一标识。该参数由平台自定义，长度最大64个字符。
     */
    private String clientId;
    /**
     * 印章ID，印章的唯一标识。
     * 不传值时，则系统将生成默认印章ID。
     * 传值时，则以传入的印章ID为准，最大长度64位,字符范围为[a-zA-Z0-9]；若印章ID已存在，则印章ID不变，更新印章图片（旧印章图片将被覆盖）。
     */
    private String sealId;
    /**
     * 印章名称，印章名称，最大50个字符。
     */
    private String sealName;
    /**
     * 印章标签，印章标签，可以与平台印章业务类型对应，最大50个字符。
     */
    private String sealTag;
    /**
     * 印章的高，印章的高（单位毫米mm），默认40mm，最大60mm，最小10mm
     * 注：建议传入图片尺寸和宽高等比例，否则印章将会根据宽高裁剪，效果可能不是最终想要的，如印章宽高想要30X40，那图片尺寸最好就是30X40的倍数
     */
    private Integer sealHeight;
    /**
     * 印章的宽，印章的宽（单位毫米mm），默认40mm，最大60mm，最小10mm
     * 注：建议传入图片尺寸和宽高等比例，否则印章将会根据宽高裁剪，效果可能不是最终想要的，如印章宽高想要30X40，那图片尺寸最好就是30X40的倍数
     */
    private Integer sealWidth;
}
