package com.dss.sdk.api.req;

import com.dss.sdk.api.base.BaseDssRequest;
import lombok.Data;
import lombok.RequiredArgsConstructor;
import lombok.experimental.Accessors;

@Accessors(chain = true)
@RequiredArgsConstructor(staticName = "of")
@Data
public class SealCreateImageRequest extends BaseDssRequest {
    /**
     * 企业或个人的唯一标识，企业或个人的唯一标识。该参数由平台自定义，长度最大64个字符。
     */
    private String clientId;
    /**
     * 印章ID，印章的唯一标识。
     * 不传值时，则系统将生成默认印章ID。
     * 传值时，则以传入的印章ID为准，最大长度64位,字符范围为[a-zA-Z0-9]；若印章ID已存在，则印章ID不变，更新印章图片（旧印章图片将被覆盖）。
     */
    private String sealId;
    /**
     * 印章名称，印章名称，最大50个字符。
     */
    private String sealName;
    /**
     * 印章标签，印章标签，可以与平台印章业务类型对应，最大50个字符。
     */
    private String sealTag;
    /**
     * 印章图片base64数据，企业或个人的印章图片base64数据，图片大小5M以内。
     */
    private String imageBase64;
    /**
     * 图片格式:png,jpg,jpeg,svg
     * png,jpg,jpeg，保存为png图片文件
     * svg格式，保存为svg和png图片文件
     */
    private String imageType;
    /**
     * 印章的高，印章的高（单位毫米mm），默认40mm，最大60mm，最小10mm
     * 注：建议传入图片尺寸和宽高等比例，否则印章将会根据宽高裁剪，效果可能不是最终想要的，如印章宽高想要30X40，那图片尺寸最好就是30X40的倍数
     */
    private Integer sealHeight;
    /**
     * 印章的宽，印章的宽（单位毫米mm），默认40mm，最大60mm，最小10mm
     * 注：建议传入图片尺寸和宽高等比例，否则印章将会根据宽高裁剪，效果可能不是最终想要的，如印章宽高想要30X40，那图片尺寸最好就是30X40的倍数
     */
    private Integer sealWidth;
}
