package com.dss.sdk.api.req;

import com.dss.sdk.api.base.BaseDssRequest;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @author Fadada
 */
@Data
@Accessors(chain = true)
public class SealPreviewRequest extends BaseDssRequest {
    /**
     * 印章样式
     */
    private String sealStyle;
    /**
     * 印章内容
     */
    private String sealText;
    /**
     * 印章规格，印章规格，即宽高（单位：毫米mm）
     */
    private String sealSize;
    /**
     * 自定义印章的高，印章的高（单位毫米mm），最大60mm，最小10mm
     */
    private Integer sealHeight;
    /**
     * 自定义印章的宽，印章的宽（单位毫米mm），最大60mm，最小10mm
     */
    private Integer sealWidth;
    /**
     * 印章颜色，印章颜色
     */
    private String sealColor;
    /**
     * 印章横排文字
     */
    private String sealHorizontalText;
    /**
     * 印章下弦文
     */
    private String sealBottomText;
}
