package com.dss.sdk.api.req;

import com.dss.sdk.api.base.BaseDssRequest;
import lombok.Data;
import lombok.RequiredArgsConstructor;
import lombok.experimental.Accessors;

@Accessors(chain = true)
@RequiredArgsConstructor(staticName = "of")
@Data
public class SealQueryRequest extends BaseDssRequest {
    /**
     * 印章在平台的唯一标识，印章制作后在平台的唯一标识。该参数由平台自定义，长度最大64个字符。
     */
    private String sealId;
    /**
     * 企业或个人的唯一标识，企业或个人的唯一标识。该参数由平台自定义，长度最大64个字符。
     */
    private String clientId;
    /**
     * 印章名称，印章名称，最大50个字符。
     */
    private String sealName;
    /**
     * 印章标签，印章标签，可以与平台印章业务类型对应，最大50个字符。
     */
    private String sealTag;

    /**
     * 游标，用于分页查询，第一次查询不传。
     */
    private String cursor;

    /**
     * 每页数量，默认为50，取值范围1-500。
     */
    private Integer limit;
}
