package com.dss.sdk.api.req;

import com.dss.sdk.api.base.BaseDssRequest;
import com.dss.sdk.api.enums.AlignTypeEnum;
import com.dss.sdk.api.enums.BoldEnum;
import lombok.Data;
import lombok.experimental.Accessors;

@Data
@Accessors(chain = true)
public class SealRemarkPreviewRequest extends BaseDssRequest {

    /**
     * 备注内容，（默认高宽、字体大小可输入300个字符）
     */
    private String content;
    /**
     * 备注区高度，默认110（取值范围A4标准10-1131px)（默认内边距5 * 2，最小字体2，所以最小值12）
     */
    private Integer fieldHeight = 110;

    /**
     * 备注区宽度，默认310（取值范围A4标准10-800px)（默认内边距5 * 2，最小字体2，所以最小值12）
     */
    private Integer fieldWidth = 310;

    /**
     * 字体大小，默认10（2-72px）
     */
    private Integer fontSize = 10;

    /**
     * #595959（默认）
     */
    private String fontRgbColor = "#595959";

    /**
     * 文字加粗， regular：不加粗 （默认）； bold：加粗 ；
     */
    private String bold = BoldEnum.REGULAR.getType();

    /**
     * 对齐方式: left：左对齐 （默认）; center：居中; right：右对齐
     */
    private String alignType = AlignTypeEnum.LEFT.getType();

    /**
     * 是否有边框，默认无边框
     */
    private Boolean isBackGround = Boolean.FALSE;
}
