package com.dss.sdk.api.req;

import com.dss.sdk.api.base.BaseDssRequest;
import lombok.Data;
import lombok.RequiredArgsConstructor;
import lombok.experimental.Accessors;

/**
 * FileSignSignRequest
 *
 * @author Fadada
 */
@Accessors(chain = true)
@RequiredArgsConstructor(staticName = "of")
@Data
public class SendSmsRequest extends BaseDssRequest {
    /**
     * 仅支持使用已启用意愿校验的文件签署交易号，不允许单独定义
     */
    private String transactionId;
    /**
     * 接收验证码的手机号
     */
    private String mobile;
    /**
     * 区号
     * 非必填，无传值时，默认为+86
     */
    private String areaCode;
}
