package com.dss.sdk.api.req;

import com.dss.sdk.api.base.BaseDssRequest;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 对公账户验证
 */
@Data
@Accessors(chain = true)
public class ZxcaApiCorpBankAccountVerifyRequest extends BaseDssRequest {

    /**
     * 认证订单号
     */
    private String transactionId;

    /**
     * 对公账户验证方式：pay_in-豸信打款至认证企业 pay_out-认证企业打款至豸信
     */
    private String paymentType;

    /**
     * 企业账户名称
     */
    private String corpBankAccountName;

    /**
     * 企业账户号（豸信打款至认证企业时，必填）
     */
    private String corpBankAccountNo;

    /**
     * 开户行支行名称（豸信打款至认证企业时，必填，可以配合“开户行查询接口”获取）
     */
    private String corpBankName;

    /**
     * 开户行联行号（豸信打款至认证企业时，必填，可以配合“开户行查询接口”接口获取）
     */
    private String corpBankId;

}
