package com.dss.sdk.api.req;

import com.dss.sdk.api.base.BaseDssRequest;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 法定代表人意愿验证
 */
@Data
@Accessors(chain = true)
public class ZxcaApiCorpLegalFaceVerifyRequest extends BaseDssRequest {

    /**
     * 认证订单号
     */
    private String transactionId;
    /**
     * 人脸识别同步回调地址（人脸识别验证时必填）
     */
    private String faceReturnUrl;

    /**
     * 是否展示人脸识别结果页，默认值: non_redirect，详见字典（人脸识别验证时传入有效）
     */
    private String faceResultType;

}
