package com.dss.sdk.api.req;

import com.dss.sdk.api.base.BaseDssRequest;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 提交企业信息
 */
@Data
@Accessors(chain = true)
public class ZxcaApiCorpTransSubmitRequest extends BaseDssRequest {

    /**
     * 认证订单号
     */
    private String transactionId;

    /**
     * 企业主体类型，company：企业 individual_business：个体工商户 others：其他组织
     */
    private String corpType;

    /**
     * 营业执照图片文件id
     */
    private String businessLicensePhoto;

    /**
     * 企业是否有名称：no=无；yes=有（仅企业主体类型为个体工商户时，该值传入有效）
     */
    private String hasCorpName;

    /**
     * 企业全称
     */
    private String corpFullName;

    /**
     * 统一社会信用代码或其他等同的编码
     */
    private String corpUnifiedIdentifier;

    /**
     * 法定代表人/经营者(如个体工商户的)/负责人的姓名
     */
    private String legalRepName;

}
