package com.dss.sdk.api.req;

import com.dss.sdk.annotation.ValidField;
import com.dss.sdk.api.base.BaseDssRequest;
import lombok.Data;
import lombok.experimental.Accessors;

@Data
@Accessors(chain = true)
public class ZxcaApiUserAuditRequest extends BaseDssRequest {
    /**
     * 证书申请订单号
     */
    @ValidField(required = true, maxLength = 30)
    private String transactionId;

    /**
     * 证件头像面图片文件ID
     * 如需上传文件，需要调用"获取文件上传预签名地址"获取文件上传地址，在上传地址(preSignUrl)有效期之前上传文件，并将文件ID(fileId)传入该值
     */
    @ValidField(required = true)
    private String idCardHeadPicture;

    /**
     * 证件背面图片文件ID
     * 如需上传文件，需要调用"获取文件上传预签名地址"获取文件上传地址，在上传地址(preSignUrl)有效期之前上传文件，并将文件ID(fileId)传入该值
     */
    @ValidField(required = true)
    private String idCardBackPicture;

    /**
     * 手势照图片文件ID
     * 如需上传文件，需要调用"获取文件上传预签名地址"获取文件上传地址，在上传地址(preSignUrl)有效期之前上传文件，并将文件ID(fileId)传入该值
     */
    @ValidField(required = true)
    private String gesturesPicture;
}
