package com.dss.sdk.api.req;

import com.dss.sdk.annotation.ValidField;
import com.dss.sdk.api.base.BaseDssRequest;
import lombok.Data;
import lombok.experimental.Accessors;

@Data
@Accessors(chain = true)
public class ZxcaApiUserFaceUrlRequest extends BaseDssRequest {
    /**
     * 证书申请订单号
     */
    @ValidField(required = true, maxLength = 30)
    private String transactionId;

    /**
     * 姓名
     */
    @ValidField(required = true)
    private String realName;

    /**
     * 个人证件类型 详见字典
     */
    @ValidField(required = true)
    private String idCertType;

    /**
     * 证件号码
     */
    @ValidField(required = true, maxLength = 30)
    private String idCertNo;

    /**
     * 同步回调类型
     */
    private String resultType;

    /**
     * 同步回调地址
     */
    @ValidField(maxLength = 200)
    private String returnUrl;
}
