package com.dss.sdk.api.req.evidence;

import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

@Data
@Accessors(chain = true)
public class RaVerificationInfo {
    /**
     * 自定义认证/意愿确认方式名称
     */
    private String verifyMode;
    /**
     * 实名方式/意愿确认扩展字段。
     * 开发者可通过扩展字段（extInfo）自定义实名认证方式的数据，入参为 extKey(对应参数的key)、extValue(对应参数的value) 配合使用。
     */
    private List<PreservationExtInfo> extInfo;
    /**
     * 验证状态，请传入“通过”
     */
    private String status;
    /**
     * 验证完成时间，请传入“验证完成时间”,格式 yyyy-MM-dd HH:mm:ss
     */
    private String verificationFinishTime;

}
