package com.dss.sdk.api.req.form;

import com.dss.sdk.api.enums.FormChooseStyleEnum;

/**
 * BaseFormFieldInfo
 * <p>
 * CheckboxFormFieldInfo
 */
@lombok.Data
public class CheckboxWidgetInfo extends BaseWidgetInfo {
    /**
     * 复选框样式。check:勾形（默认）；circle:圆形；cross:叉形；diamond:菱形；square :方形；star:星形；
     */
    private String checkboxType = FormChooseStyleEnum.CHECK.getReadValue();
    /**
     * 是否选中 默认不选中
     */
    private boolean checked = false;
    /**
     * 域名
     */
    private String fieldName;
//    /**
//     * 复选框对应文本内容
//     */
//    private String text;
    /**
     * 表单控件提示(工具提示)
     */
    private String tooltip;
    private boolean transparent = false;
}
