package com.dss.sdk.api.req.form;

import com.dss.sdk.annotation.ValidField;
import com.dss.sdk.api.base.BaseDssRequest;
import com.dss.sdk.api.dto.CoordinateInfo;
import com.dss.sdk.api.enums.CheckFlagEnum;
import com.dss.sdk.api.enums.FillInPdfReqFontTypeEnum;
import lombok.Data;

import java.util.List;

/**
 * @author Fadada
 */
@Data
public class FileFormRequest extends BaseDssRequest {
    @ValidField(required = true)
    private String fileId;
    /**
     * 是否使用副本，false（默认）: 在源文件基础上添加控件； true: 创建一个文件副本上，并在副本上添加控件，源文件保持不变
     */
    private boolean useCopy = false;
    // ==================表单域样式&基本信息==================
    /**
     * 全局表单域字体大小
     */
    private Float fontSize;
    /**
     * 全局表单域字体类型 参见附录二 FillInPdfReqFontType 默认为宋体
     */
    private String fontType = FillInPdfReqFontTypeEnum.SONG_TI.getReadValue();
    /**
     * 检查表单域是否存在 。 ignore（不检查）（默认）    check（检查）
     */
    private String formFieldCheckFlag = CheckFlagEnum.IGNORE.getReadValue();
    /**
     * 是否使表单域扁平化，设置为true时，填充后表单域将无法编辑，下次调用填充无法找到表单域信息；设置为false，则填充表单域依然可编辑 默认值为true
     */
    private boolean formFlattening = true;

    /**
     * 自定义坐标参考系信息。
     */
    private CoordinateInfo coordinateInfo;

    // ==================表单域信息==================
    /**
     * 文本输入框集合
     */
    private List<TextWidgetInfo> textWidgetInfos;
    /**
     * 单选框组（一组包含多个单选，可以有多个组）
     */
    private List<RadioGroupWidgetInfo> radioGroupWidgetInfos;
    /**
     * 复选框组件
     */
    private List<CheckboxWidgetInfo> checkboxWidgetInfos;
    /**
     * key对应表单域域名，值对应formdata对象
     */
    private List<WidgetData> widgetDataInfos;
    /**
     * 表头信息与表格内容数据
     */
    private List<TableWidgetInfo> tableWidgetInfos;
    /**
     * 图片表单域信息
     */
    private List<PicWidgetInfo> imageWidgetInfos;

    /** 签名表单域信息   */
    private List<SignWidgetInfo> signWidgetInfos;

    private SignFieldInfo signFieldInfo;
}
