package com.dss.sdk.api.req.form;

import com.dss.sdk.api.enums.TableHeaderDirectionEnum;
import com.dss.sdk.api.req.table.TableWidgetHeaderData;
import com.dss.sdk.api.req.table.TableWidgetInsertWay;
import com.dss.sdk.api.req.table.TableWidgetPosition;
import com.dss.sdk.api.req.table.TableWidgetStyle;
import lombok.Data;

@Data
public class TableWidgetInfo {
    /**
     * table数据
     */
    private TableWidgetHeaderData tableData;
    /**
     * table插入方式
     */
    private TableWidgetInsertWay tableInsertWay;
    /**
     * table位置信息 table可以为空 就按照默认来
     */
    private TableWidgetPosition tablePosition = new TableWidgetPosition();
    /**
     * table样式
     */
    private TableWidgetStyle tableStyle = new TableWidgetStyle();
    /**
     * 表头方向，1为水平方向，2为垂直方向
     */
    private String headerDirection = TableHeaderDirectionEnum.HORIZON.getReadValue();
}
