package com.dss.sdk.api.req.form;

import com.dss.sdk.api.enums.TextWidgetAlignTypeEnum;

/**
 * BaseFormFieldInfo
 * <p>
 * TextFormFieldInfo
 */
@lombok.Data
public class TextWidgetInfo extends BaseWidgetInfo {
    /**
     * 对齐方式: left：左对齐 （默认）; center：居中; right：右对齐
     */
    private String alignType = TextWidgetAlignTypeEnum.LEFT.getReadValue();
    /**
     * 边框颜色 默认为无边框
     */
    private String borderRgbColor;
    /**
     * 文本域域名
     */
    private String fieldName;
    /**
     * 文本框最大字符串长度 默认不限制长度
     */
    private Integer maxCharacterLength;
    /**
     * 是否多行显示 默认false
     */
    private boolean multiline = false;
    /**
     * 表单控件提示(工具提示)
     */
    private String tooltip;
    /**
     * 文本域填充色是否透明 默认不透明
     */
    private boolean transparency = false;
}
