package com.dss.sdk.api.req.form;

import com.dss.sdk.api.enums.FillInPdfReqFontTypeEnum;
import lombok.Data;

/**
 * PdfFormData
 */
@Data
public class WidgetData {
    /**
     * 表单域的名称
     */
    private String fieldName;
    /**
     * 表单域对应值，若为空不做任何操作
     */
    private String fieldValue;
    /**
     * 表单域字体大小，若缺省则参照全局fontSize
     */
    private Float fontSize;
    /**
     * 表单域字体类型，若缺省则参照全局fontType
     */
    private String fontType = FillInPdfReqFontTypeEnum.SONG_TI.getReadValue();
    /**
     * 表单域是否透明，默认不透明
     */
    private boolean transparent = false;
}
