package com.dss.sdk.api.req.merge;

import com.dss.sdk.api.enums.FileTypeEnum;
import com.dss.sdk.api.req.form.FileFormRequest;
import com.dss.sdk.file.FileItem;
import com.dss.sdk.request.DssUploadRequest;
import lombok.Data;

import java.util.HashMap;
import java.util.Map;

/**
 * @author: Fadada
 */
@Data
public class FileUploadAddDataRequest extends FileFormRequest implements DssUploadRequest {
    //文件流，文件流与Url的方式二选一，不允许同时选择；传文档文件，则按照文件流的方式创建文件并返回文件id；选择文件路径，则从Url中下载文件后创建文件并返回文件id (optional)
    private FileItem file;
    //文件获取链接地址，文件流与Url的方式二选一，不允许同时选择；传文档文件，则按照文件流的方式创建文件并返回文件id；选择文件路径，则从Url中下载文件后创建文件并返回文件id (optional)
    private String fileUrl;
    //转换类型，1:pdf（默认）、2:ofd (optional)
    private String transferType = FileTypeEnum.PDF_FILE.getReadValue();
    //文件的摘要哈希值，当上传了摘要值时，文件上传完之后，需要先做完整性比对，若比对不上，则报错提示“文件摘要值与实际文件不匹配” (optional)
    private String fileHash;
    //文件完整名称（需带上文件后缀） (optional)
    private String fileName;
    //异步回调地址，文档上传成功后产生回调，基于返回的fileId识别回调  (optional)
    private String notifyUrl;

    @Override
    public Map<String, FileItem> getFileParams() {
        return new HashMap<String, FileItem>(1) {{
            put("file", file);
        }};
    }
}
