package com.dss.sdk.api.req.operate;


import com.dss.sdk.api.dto.FileBasinInfo;
import com.dss.sdk.api.req.EuiCommonRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
public class FileFormUrlRequest extends EuiCommonRequest {

    /**
     * 业务自定义签署交易号，最大长度64位
     */
    private String transactionId;

    /**
     * 是否使用副本，是否使用文件副本。false（默认）: 在源文件上操作； true: 创建一个文件副本，并在副本上操作，源文件保持不变 。
     */
    private boolean useCopy;

    /**
     * 文件列表
     */
    private List<FileBasinInfo> fileInfos;


}

