package com.dss.sdk.api.req.table;

import com.dss.sdk.api.enums.TableFontStyleEnum;
import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;

/**
 * 表格数据字体
 * <p>
 * TableFont
 * <p>
 * 表头字体样式  默认为12px,normal
 * <p>
 * 表头字体样式 默认为12px,normal
 */
@lombok.Data
@AllArgsConstructor
@NoArgsConstructor
public class TableFont {
    /**
     * 表格数据字体大小 默认12px
     */
    private Float size = 12f;
    /**
     * 表格数据字体样式。normal：正常（默认）；bold：粗体；italic：斜体
     */
    private String style = TableFontStyleEnum.NORMAL.getReadValue();
}
