package com.dss.sdk.api.req.table;

import com.dss.sdk.api.enums.CellHorizontalAlignmentEnum;

/**
 * 标题
 */
@lombok.Data
public class TableWidgetBaseHeader {
    /**
     * 表头的对齐方式，align_left：居左；align_center：居中（默认）；align_right：居右
     */
    private String alignment = CellHorizontalAlignmentEnum.ALIGN_CENTER.getReadValue();
    /**
     * 一级标头背景色,默认浅灰色
     */
    private String background = "#C0C0C0";
    /**
     * 表头字体样式 默认为12px,normal
     */
    private TableFont font = new TableFont(12.0f, "normal");
}
