package com.dss.sdk.api.req.table;

import com.dss.sdk.api.enums.InsertWayEnum;

/**
 * table插入方式
 */
@lombok.Data
public class TableWidgetInsertWay {
    /**
     * 插入表格的方式，new_page：新建页面添加table(默认)；keyword：在某个关键字后添加table；location：指定页面及页面纵坐标方式插入。 默认为0
     */
    private String way = InsertWayEnum.NEW_PAGE.getReadValue();
    /**
     * 在第几页（此处指：未填充前原pdf 的第几页）开始插入表格，即在第一页签章，传值1。 insertWay=new_page,不能为空
     */
    private Integer pageBegin;
    /**
     * 表格插入关键字下方insertWay=keyword,不能为空
     */
    private String keyword;
    /**
     * 表格插入PDF的纵坐标位置，以左上角为原点；insertWay=location,不能为空
     */
    private Double verticalCoordinate;
}
