package com.dss.sdk.api.req.table;

import com.dss.sdk.api.enums.CellHorizontalAlignmentEnum;

/**
 * table位置信息 table可以为空 就按照默认来
 */
@lombok.Data
public class TableWidgetPosition {
    /**
     * 表格对齐方式，align_left：居左；align_center：居中（默认）；align_right：居右
     */
    private String tableHorizontalAlignment = CellHorizontalAlignmentEnum.ALIGN_CENTER.getReadValue();
    /**
     * table水平偏移量，默认0.0。向右偏移值为正数，向左偏移值为负数
     */
    private Float tableHorizontalOffset = 0f;
    /**
     * 表格后间距，默认10.0 值范围为0.0-200.0
     */
    private Float tableSpacingAfter = 10.f;
    /**
     * 表格前间距，默认10.0 值范围为0.0-200.0
     */
    private Float tableSpacingBefore = 10.0f;
    /**
     * table宽度的百分比，默认100
     */
    private Float tableWidthPercentage = 100f;
}
