package com.dss.sdk.api.resp;

import lombok.Data;
import lombok.experimental.Accessors;

@Data
@Accessors(chain = true)
public class CertApplyInfoResponse {
    /**
     * 证书申请订单号
     */
    private String transactionId;
    /**
     * 客户系统中的用户唯一标识
     */
    private String clientId;
    /**
     * 证书类型，person:个人证书，company:企业证书
     */
    private String certType;
    /**
     * 证书申请状态，apply:申请中，success:申请成功，fail:申请失败
     */
    private String applyStatus;
    /**
     * 实名认证事件编码
     * 企业：
     * transaction_in_progress	进行中	-
     * legal_rep_self_success	认证成功	法定代表人认证
     * legal_rep_self_failed	认证失败	法定代表人认证
     * legal_rep_auth_success	认证成功	邀请法定代表人授权认证
     * legal_rep_auth_failed	认证失败	邀请法定代表人授权认证
     * letter_pay_letter_success	进行中	授权公函+对公账户验证
     * letter_pay_letter_failed	进行中(企业/个体工商户)认证失败(其他组织)	授权公函+对公账户验证
     * letter_pay_pay_in_success	进行中	授权公函+对公账户验证
     * letter_pay_pay_in_failed	进行中	授权公函+对公账户验证
     * letter_pay_pay_out_failed	进行中	授权公函+对公账户验证
     * letter_pay_failed	认证失败	授权公函+对公账户验证
     * letter_pay_pay_success	进行中	授权公函+对公账户验证
     * letter_pay_success	认证成功	授权公函+对公账户验证
     * letter_paper_letter_failed	进行中(企业/个体工商户)认证失败(其他组织)	授权公函+邮寄原件验证
     * letter_paper_letter_success	进行中	授权公函+邮寄原件验证
     * letter_paper_success	认证成功	授权公函+邮寄原件验证
     * letter_paper_failed	认证失败	授权公函+邮寄原件验证
     * 个人：
     * face_success	认证成功	人脸识别认证
     * face_failed	认证失败	人脸识别认证
     * mobile_success	认证成功	实名手机号认证
     * mobile_failed	认证失败	实名手机号认证
     * bank_account_success	认证成功	个人银行卡认证
     * bank_account_failed	认证失败	个人银行卡认证
     * manual_audit_in_audit	进行中	人工审核
     * manual_audit_success	认证成功	人工审核认证
     * manual_audit_failed	认证失败	人工审核认证
     */
    private String verificationEventCode;
    /**
     * 实名认证方式
     * 企业：
     * legal_rep_self（法定代表人认证）
     * legal_rep_auth（法定代表人授权认证）
     * letter_pay（授权公函+对公打款认证）
     * letter_paper（授权公函邮寄原件认证
     * 个人：
     * face（人脸识别认证）
     * mobile（实名手机号三要素认证）
     * bank_account（个人银行卡四要素认证）
     * manual_audit（人工审核认证）
     */
    private String verificationType;
    /**
     * 返回描述信息
     */
    private String resultMessage;
    /**
     * 异步回调地址
     * 仅在字段值不为null时才包含该字段
     */
    private String notifyUrl;
    /**
     * 方案ID 为空时默认获取应用ID下的默认方案ID
     */
    private String planId;
    /**
     * 证书算法
     */
    private String certAlg;
    /**
     * 接入方标识
     */
    private String appId;
    /**
     * ras签名证书信息
     */
    private CertInfoResponse rsaCertInfo;
    /**
     * sm2签名证书信息
     */
    private CertInfoResponse sm2CertInfo;
}
