package com.dss.sdk.api.resp;

import lombok.Data;

/**
 * 新增印章返回的对象
 *
 * @author maom@fadada.com
 * @since 2022/07/07 10:32
 */
@Data
// 新增SVG印章返回的对象
public class CertPageInfoResponse {
    /**
     * 证书编号，证书编号，证书唯一标识，用于文件签署
     */
    private String certificateId;
    /**
     * 证书主体名称，证书主体名称，个人为姓名，企业为企业全称
     */
    private String name;
    /**
     * 证书主体身份编码，证书主体身份编码，个人为身份证，企业为组织机构代码
     */
    private String identNo;
    /**
     * 证书序列号，证书序列号
     */
    private String certSN;
    /**
     * 证书生效时间，证书生效时间
     */
    private String certStartTime;
    /**
     * 证书失效时间，证书失效时间
     */
    private String certEndTime;
    /**
     * 证书类型，证书类型，取值范围：personal（个人证书）corporate（企业证书）
     */
    private String certType;
    /**
     * 证书算法，证书算法：RSA、SM2
     */
    private String certAlg;
    /**
     * 企业或个人在平台的唯一标识。，企业或个人在平台的唯一标识。该参数由平台自定义，长度最大64个字符。
     */
    private String clientId;
    /**
     * 应用ID，应用ID，控制台设置的应用ID
     */
    private String appId;
    /**
     * 颁发机构，证书颁发机构
     */
    private String caInstitution;
}
