package com.dss.sdk.api.resp;

import lombok.Data;

import java.util.Date;

/**
 * FilePreGetUploadStatusResponse
 *
 * @author Fadada
 */
@Data
public class FileGetFileInfoResponse {
    /**
     * 文件ID，文件在本地电子签系统的唯一识别标识
     */
    private String fileId;
    /**
     * 文件名称，已签署文件名称（含文件后缀）
     */
    private String fileName;
    /**
     * 文件Hash，文件的摘要值，用于做文件完整性比对
     */
    private String fileHash;
    private Long fileSize;
    /**
     * 文件状态，文件状态
     */
    private String fileStatus;
    /**
     * 文件转换失败原因
     */
    private String failReason;
    /**
     * 创建时间，文件创建时间，格式yyyy-MM-dd HH:mm:ss
     */
    private Date createdTime;
    /**
     * 文件下载地址，文件下载地址，连接一次有效，失效后可重复获取
     */
    private String fileUrl;
}
