package com.dss.sdk.api.resp;

/**
 * RemarkSignResultVO
 *
 * @author wangyulong
 * @date 2024/8/6
 */
@lombok.Data
public class RemarkSignResultVO {

    /**
     * 文件编号，备注章所属的文件编号
     */
    private String fileId;
    /**
     * 证书编号，备注章使用的证书编号
     */
    private String certificateId;
    /**
     * 备注内容，备注章内容
     */
    private String content;
    /**
     * 签章页码，签章页码，第一页从1开始，以此类推；
     */
    private Integer pageNum;
    /**
     * x轴坐标，签章中心点的x轴，以页面左上角为原点开始计算，正数向右，负数无效
     */
    private Double x;
    /**
     * y轴坐标，签章中心点的y轴，以页面左上角为原点开始计算，正数向下，负数无效
     */
    private Double y;
}