package com.dss.sdk.api.resp;

import lombok.Data;

import java.util.Date;

/**
 * 新增印章返回的对象
 *
 * @author Fadada
 * @since 2022/07/07 10:32
 */
@Data
// 新增SVG印章返回的对象
public class SealStyleInfoResponse {
    /**
     * 个人或企业的唯一标识，个人或企业的唯一标识
     */
    private String clientId;
    /**
     * 印章唯一标识，印章唯一标识
     */
    private String sealId;
    /**
     * 印章图片名称，印章图片名称
     */
    private String sealName;
    /**
     * 印章标签，印章标签
     */
    private String sealTag;
    /**
     * 印章样式，印章制作样式：
     * round（圆形）
     * round_no_star（圆形-不带星）
     * oval（椭圆）
     * rectangle（矩形）
     * square（方形）
     * image：图片印章
     */
    private String sealStyle;
    /**
     * 印章PNG格式文件ID，印章PNG文件唯一标识，可通过[文件下载]接口下载印章图片文件
     */
    private String pngFileId;
    /**
     * 印章SVG格式文件ID，印章SVG文件唯一标识，通过[制作图片印章]接口制作的非SVG格式印章，参数返回为空，可能可通过[文件下载]接口下载印章图片文件
     */
    private String svgFileId;
    /**
     * 印章的高，sealHeight
     */
    private Integer sealHeight;
    /**
     * 印章的宽，印章的宽（单位：毫米mm）
     */
    private Integer sealWidth;
    /**
     * 创建时间
     */
    private Date createdTime;
}
