package com.dss.sdk.api.resp;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 对公账户验证
 */
@Data
@Accessors(chain = true)
public class ZxcaApiCorpBankAccountVerifyResponse implements Serializable {
    private static final long serialVersionUID = -3896581173339298640L;

    /**
     * 认证订单ID
     */
    private String transactionId;

    /**
     * 认证订单状态，详见字典
     */
    private String transactionStatus;

    /**
     * 当前认证状态，详见字典
     */
    private String verificationStatus;

    /**
     * 对公打款验证状态：进行中(in_progress)、成功(success)、失败(failed)
     */
    private String paymentVerificationStatus;

    /**
     * 豸信打款状态（仅豸信打款至认证企业时返回）：打款中(paying)、打款成功(success)、打款失败(failed)
     */
    private String payInStatus;

    /**
     * 企业打款状态（仅认证企业打款至豸信时返回）：待企业打款(await_pay)、验证通过(success)、验证不通过(failed)
     */
    private String payOutStatus;

    /**
     * 指定汇款金额（仅认证企业打款至豸信时返回）
     */
    private String requiredAmount;

    /**
     * 指定汇款账户名称（仅认证企业打款至豸信时返回）
     */
    private String payOutBankAccountName;

    /**
     * 指定汇款账户账号（仅认证企业打款至豸信时返回）
     */
    private String payOutBankAccountNo;

    /**
     * 指定汇款账户开户行名称（仅认证企业打款至豸信时返回）
     */
    private String payOutBankName;

    /**
     * 汇款有效期限（仅认证企业打款至豸信时返回）
     */
    private String payOutExpireTime;

}
